--[[
Copyright (C) GtX (Andy), 2020

Author: GtX | Andy
Date: 05.05.2020
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

MultiplayerVehicleKeysSettingsEvent = {}

local MultiplayerVehicleKeysSettingsEvent_mt = Class(MultiplayerVehicleKeysSettingsEvent, Event)
InitEventClass(MultiplayerVehicleKeysSettingsEvent, "MultiplayerVehicleKeysSettingsEvent")

function MultiplayerVehicleKeysSettingsEvent.emptyNew()
    return Event.new(MultiplayerVehicleKeysSettingsEvent_mt)
end

function MultiplayerVehicleKeysSettingsEvent.new(isReset, keyLimit, masterKeyEnabled, vehicle)
    local self = MultiplayerVehicleKeysSettingsEvent.emptyNew()

    self.isReset = isReset
	self.keyLimit = keyLimit
	self.masterKeyEnabled = masterKeyEnabled
	self.vehicle = vehicle

    return self
end

function MultiplayerVehicleKeysSettingsEvent:readStream(streamId, connection)
    self.isReset = streamReadBool(streamId)

    if self.isReset then
		if streamReadBool(streamId) then
			self.vehicle = NetworkUtil.readNodeObject(streamId)
		end
	else
        self.keyLimit = streamReadUIntN(streamId, MultiplayerVehicleKeysManager.KEYS_NUM_BITS)
		self.masterKeyEnabled = streamReadBool(streamId)
    end

    self:run(connection)
end

function MultiplayerVehicleKeysSettingsEvent:writeStream(streamId, connection)
    if streamWriteBool(streamId, self.isReset) then
		if streamWriteBool(streamId, self.vehicle ~= nil) then
			NetworkUtil.writeNodeObject(streamId, self.vehicle)
		end
	else
        streamWriteUIntN(streamId, self.keyLimit or 2, MultiplayerVehicleKeysManager.KEYS_NUM_BITS)
		streamWriteBool(streamId, self.masterKeyEnabled == true)
    end
end

function MultiplayerVehicleKeysSettingsEvent:run(connection)
    if g_multiplayerVehicleKeys ~= nil then
        if self.isReset then
            g_multiplayerVehicleKeys:restoreAllVehicleKeys(self.vehicle, true)
        else
            g_multiplayerVehicleKeys:setKeyLimit(self.keyLimit, true)
			g_multiplayerVehicleKeys:setMasterKeyEnabled(self.masterKeyEnabled, true)
        end
		
		g_multiplayerVehicleKeys:onSettingsChanged()

        if not connection:getIsServer() then
            g_server:broadcastEvent(self, false, connection)
        end
    end
end

function MultiplayerVehicleKeysSettingsEvent.sendEvent(isReset, keyLimit, masterKeyEnabled, vehicle, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_currentMission:getIsServer() then
            g_server:broadcastEvent(MultiplayerVehicleKeysSettingsEvent.new(isReset, keyLimit, masterKeyEnabled, vehicle), false)
        else
            g_client:getServerConnection():sendEvent(MultiplayerVehicleKeysSettingsEvent.new(isReset, keyLimit, masterKeyEnabled, vehicle))
        end
    end
end
